package fm.qingting.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.bumptech.glide.Glide;

import java.util.ArrayList;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.callbacks.QTCallback;
import fm.qingting.qtsdk.entity.QTListEntity;
import fm.qingting.qtsdk.entity.SimpleChannel;

import static android.widget.Toast.LENGTH_SHORT;

/**
 * Created by lee on 2018/1/23.
 */

public class SearchListActivity extends AppCompatActivity {
    EditText mEditText;
    Button mButton;
    TabLayout mTabLayout;
    RecyclerView mRecyclerView;
    SimpleAdapter listAdapter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_list);
        mEditText = findViewById(R.id.et_search);
        findViewById(R.id.ll_search).setVisibility(View.VISIBLE);
        mTabLayout = findViewById(R.id.tab);
        mRecyclerView = findViewById(R.id.list);
        mButton = findViewById(R.id.bt_search);
        listAdapter = new SimpleAdapter<SimpleChannel>() {
            @Override
            public void bindData(SimpleHolder holder, final SimpleChannel object) {
                holder.mTextView.setText(object.getTitle());
                Glide.with(holder.itemView.getContext()).load(object.getThumb()).into(holder.mImageView);
                holder.mLinearLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                    switch (object.getType()){
                        case "channel_live":
                            Intent intent = new Intent(v.getContext(), RadioDetailsListActivity.class);
                            intent.putExtra(DetailsActivity.CHANNEL_ID, object.getId());
                            v.getContext().startActivity(intent);
                            break;
                        case "channel_ondemand":
                            intent = new Intent(v.getContext(), DetailsActivity.class);
                            intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                            v.getContext().startActivity(intent);
                            break;
                        case "program_ondemand":
                            ArrayList<Integer> programIds = new ArrayList();
                            programIds.add(object.getId());
                            PlayerActivity.Companion.start(SearchListActivity.this, object.getChannelId(), programIds);
                            break;}
                    }

                });
            }
        };
        mRecyclerView.setLayoutManager(new LinearLayoutManager(getBaseContext()));
        mRecyclerView.setAdapter(listAdapter);
        TabLayout.Tab tab = mTabLayout.newTab();
        tab.setText("广播电台");
        tab.setTag("channel_live");
        mTabLayout.addTab(tab);
        tab = mTabLayout.newTab();
        tab.setText("点播专辑");
        tab.setTag("channel_ondemand");
        mTabLayout.addTab(tab);
        tab = mTabLayout.newTab();
        tab.setText("点播专辑节目");
        tab.setTag("program_ondemand");
        mTabLayout.addTab(tab);
        mButton.setOnClickListener(new View.OnClickListener()

        {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(mEditText.getText().toString())) {
                    Toast.makeText(getBaseContext(), "关键词不能为空", Toast.LENGTH_SHORT);
                    return;
                }
                switch (mTabLayout.getSelectedTabPosition()) {
                    case 0:
                        requestList(mEditText.getText().toString(), "channel_live");
                        break;
                    case 1:
                        requestList(mEditText.getText().toString(), "channel_ondemand");
                        break;
                    case 2:
                        requestList(mEditText.getText().toString(), "program_ondemand");
                        break;
                }
            }
        });
//        mTabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
//            @Override
//            public void onTabSelected(TabLayout.Tab tab) {
//                requestList(mEditText.getText().toString(), (String) tab.getTag());
//            }
//
//            @Override
//            public void onTabUnselected(TabLayout.Tab tab) {
//
//            }
//
//            @Override
//            public void onTabReselected(TabLayout.Tab tab) {
//
//            }
//        });
    }


    private void requestList(String keyword, String type) {
        QTSDK.search(keyword, type, null, 1, new QTCallback<QTListEntity<SimpleChannel>>() {

            @Override
            public void done(QTListEntity<SimpleChannel> result, QTException e) {
                if (e == null) {
                    if (result != null) {
                        listAdapter.items = result.getData();
                        listAdapter.notifyDataSetChanged();
                    }
                } else {
                    Toast.makeText(getBaseContext(), e.getMessage(), LENGTH_SHORT).show();
                }
            }
        });
    }
}
